<!DOCTYPE html>
<html>
<head>
    <title>Laporan Presensi Asrama</title>
    <style>
        @page { size: A4 landscape; margin: 15mm; }
        body { font-family: sans-serif; font-size: 11px; margin: 0; padding: 0; }
        .page-break { page-break-after: always; }
        .header { text-align: center; }
        .header h2, .header h3, .header p { margin: 2px 0; }
        .details { margin-bottom: 10px; }
        .details table { width: 100%; border: none; }
        .details td { padding: 2px; }
        .table-data { width: 100%; border-collapse: collapse; margin-top: 8px; font-size: 10px; }
        .table-data th, .table-data td { border: 1px solid #000; padding: 4px; text-align: center; }
        .table-data th { background-color: #f0f0f0; }
        .text-left { text-align: left !important; }
        .nama-siswa { font-size: 9px; }
        .signature { margin-top: 10px; }
        .signature table { width: 100%; border: none; }
        .signature td { padding: 8px; vertical-align: top; text-align: center; }
        .signature p { margin: 3px 0; }
        .signature .space { height: 40px; }
    </style>
</head>
<body>

<?php
    $base64_kop = '';
    $path = public_path('asset/KOP-PONTREN.png');
    if (file_exists($path)) {
        $type = pathinfo($path, PATHINFO_EXTENSION);
        $data = file_get_contents($path);
        $base64_kop = 'data:image/' . $type . ';base64,' . base64_encode($data);
    }
?>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $kamars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kamar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $jenisPresensis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jenis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="page-break">
            <!-- Kop Surat -->
            <div class="header">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($base64_kop): ?>
                    <img src="<?php echo e($base64_kop); ?>" style="width: 100%; height: auto;">
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
         
            <!-- Report Info -->
            <div class="details">
                <table>
                    <tr>
                        <td width="15%"><strong>Laporan</strong></td>
                        <td width="2%">:</td>
                        <td>Presensi <?php echo e($jenis->nama); ?></td>
                        <td width="15%"><strong>Kamar</strong></td>
                        <td width="2%">:</td>
                        <td><?php echo e($kamar->nama_kamar); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Tanggal</strong></td>
                        <td>:</td>
                        <td>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($filters['dari'])): ?>
                                <?php echo e(\Carbon\Carbon::parse($filters['dari'])->format('d M Y')); ?>

                            <?php else: ?>
                                Awal
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            s/d
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($filters['sampai'])): ?>
                                <?php echo e(\Carbon\Carbon::parse($filters['sampai'])->format('d M Y')); ?>

                            <?php else: ?>
                                Akhir
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </td>
                        <td><strong>Wali Kamar</strong></td>
                        <td>:</td>
                        <td><?php echo e($kamar->waliKamar->name ?? '-'); ?></td>
                    </tr>
                </table>
            </div>

            <!-- Table -->
            <table class="table-data">
                <thead>
                    <tr>
                        <th width="3%">No</th>
                        <th width="10%">NISN</th>
                        <th width="18%">Nama Santri</th>
                        <th width="8%">B/H</th>
                        <th width="5%">S</th>
                        <th width="8%">B/I</th>
                        <th width="8%">T/A</th>
                        <th width="6%">%</th>
                        <th width="34%">Keterangan</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                        $no = 1; 
                        $hasData = false;
                    ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $kamar->siswas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $siswa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            // Optimized: Use the pre-calculated aggregate array
                            // Structure: $attendanceData[siswa_id][jenis_id][status] = count
                            $studentStats = $attendanceData[$siswa->id][$jenis->id] ?? [];

                            $hadir = $studentStats['hadir'] ?? 0;
                            $sakit = $studentStats['sakit'] ?? 0;
                            $izin = $studentStats['izin'] ?? 0;
                            $alpha = $studentStats['alpha'] ?? 0;
                            
                            $total = $hadir + $sakit + $izin + $alpha;
                            if ($total > 0) $hasData = true; 
                            $percent = $total > 0 ? round(($hadir / $total) * 100, 1) : 0;

                            // Get keterangan summary
                            $keteranganList = $keteranganData[$siswa->id][$jenis->id] ?? [];
                            $keteranganText = '';
                            if (!empty($keteranganList)) {
                                // Group by status and show count
                                $grouped = [];
                                foreach ($keteranganList as $ket) {
                                    $status = $ket['status'];
                                    if (!isset($grouped[$status])) {
                                        $grouped[$status] = [];
                                    }
                                    $grouped[$status][] = $ket['keterangan'];
                                }
                                
                                $parts = [];
                                foreach ($grouped as $status => $keterangans) {
                                    $statusLabel = strtoupper(substr($status, 0, 1)); // S, I, A
                                    $count = count($keterangans);
                                    // Show first keterangan as sample
                                    $sample = mb_substr($keterangans[0], 0, 30);
                                    if (mb_strlen($keterangans[0]) > 30) $sample .= '...';
                                    $parts[] = "{$statusLabel}: {$sample}" . ($count > 1 ? " (+".($count-1).")" : "");
                                }
                                $keteranganText = implode('; ', $parts);
                            }
                        ?>
                        <tr>
                            <td><?php echo e($no++); ?></td>
                            <td><?php echo e($siswa->nisn); ?></td>
                            <td class="text-left nama-siswa"><?php echo e($siswa->nama); ?></td>
                            <td><?php echo e($hadir); ?></td>
                            <td><?php echo e($sakit); ?></td>
                            <td><?php echo e($izin); ?></td>
                            <td><?php echo e($alpha); ?></td>
                            <td><?php echo e($percent); ?>%</td>
                            <td class="text-left" style="font-size: 8px;"><?php echo e($keteranganText ?: '-'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>
            </table>

            <!-- Signature -->
            <div class="signature">
                <table width="100%" style="page-break-inside: auto;">
                    <tr style="page-break-inside: avoid;">
                        <!-- Top Left: 2. Koor Asrama -->
                        <td width="50%" align="center">
                            <br>
                            <p>Koordinator Asrama <?php echo e($kamar->jenis_kelamin === 'L' ? 'Putra' : 'Putri'); ?></p>
                            <div class="space"></div>
                            <p><strong><?php echo e(($kamar->jenis_kelamin === 'L' ? $kamar->madrasah->nama_koordinator_asrama_putra : $kamar->madrasah->nama_koordinator_asrama_putri) ?? '.........................'); ?></strong></p>
                        </td>
                        <!-- Top Right: 1. Wali Kamar -->
                        <td width="50%" align="center">
                            <p>Padang Panjang, <?php echo e(date('d F Y')); ?><br>Wali Kamar</p>
                            <div class="space"></div>
                            <p><strong><?php echo e($kamar->waliKamar->name ?? '.........................'); ?></strong></p>
                        </td>
                    </tr>
                    <tr style="page-break-inside: avoid;">
                        <!-- Bottom Left: 4. Mudir -->
                        <td width="50%" align="center">
                            <div style="height: 15px;"></div>
                            <p>Mudir</p>
                            <div class="space"></div>
                            <p><strong><?php echo e($kamar->madrasah->nama_mudir ?? '.........................'); ?></strong></p>
                        </td>
                        <!-- Bottom Right: 3. Wadir III -->
                        <td width="50%" align="center">
                            <div style="height: 15px;"></div>
                            <p>Wadir III Bidang Pengasuhan</p>
                            <div class="space"></div>
                            <p><strong><?php echo e($kamar->madrasah->nama_wadir_pengasuhan ?? '.........................'); ?></strong></p>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

</body>
</html>
<?php /**PATH /home/ilwa/project/absensikauman/resources/views/exports/laporan-asrama-pdf.blade.php ENDPATH**/ ?>