<div class="space-y-4">
    <div class="overflow-x-auto">
        <table class="w-full text-sm">
            <thead>
                <tr class="border-b border-gray-200 dark:border-gray-700">
                    <th class="px-4 py-2 text-left font-semibold text-gray-700 dark:text-gray-300">Tanggal</th>
                    <th class="px-4 py-2 text-left font-semibold text-gray-700 dark:text-gray-300">Jenis Presensi</th>
                    <th class="px-4 py-2 text-left font-semibold text-gray-700 dark:text-gray-300">Status</th>
                    <th class="px-4 py-2 text-left font-semibold text-gray-700 dark:text-gray-300">Keterangan</th>
                </tr>
            </thead>
            <tbody>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="border-b border-gray-100 dark:border-gray-800 hover:bg-gray-50 dark:hover:bg-gray-800/50">
                        <td class="px-4 py-3 text-gray-900 dark:text-gray-100">
                            <?php echo e(\Carbon\Carbon::parse($detail->presensiAsrama->tanggal)->format('d/m/Y')); ?>

                        </td>
                        <td class="px-4 py-3 text-gray-900 dark:text-gray-100">
                            <?php echo e($detail->presensiAsrama->jenisPresensiAsrama->nama ?? '-'); ?>

                        </td>
                        <td class="px-4 py-3">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                <?php if($detail->status === 'sakit'): ?> bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200
                                <?php elseif($detail->status === 'izin'): ?> bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200
                                <?php elseif($detail->status === 'alpha'): ?> bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200
                                <?php endif; ?>">
                                <?php echo e(ucfirst($detail->status)); ?>

                            </span>
                        </td>
                        <td class="px-4 py-3 text-gray-900 dark:text-gray-100">
                            <?php echo e($detail->keterangan); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <div class="text-xs text-gray-500 dark:text-gray-400 mt-4">
        Total: <?php echo e($details->count()); ?> keterangan
    </div>
</div>
<?php /**PATH /home/ilwa/project/absensikauman/resources/views/filament/components/keterangan-detail-asrama.blade.php ENDPATH**/ ?>