<div class="space-y-4">
    <div class="overflow-x-auto">
        <table class="w-full text-sm">
            <thead>
                <tr class="border-b border-gray-200 dark:border-gray-700">
                    <th class="px-4 py-2 text-left font-semibold text-gray-700 dark:text-gray-300">Tanggal</th>
                    <th class="px-4 py-2 text-left font-semibold text-gray-700 dark:text-gray-300">Jenis Presensi</th>
                    <th class="px-4 py-2 text-left font-semibold text-gray-700 dark:text-gray-300">Status</th>
                    <th class="px-4 py-2 text-left font-semibold text-gray-700 dark:text-gray-300">Keterangan</th>
                </tr>
            </thead>
            <tbody>
                @foreach($details as $detail)
                    <tr class="border-b border-gray-100 dark:border-gray-800 hover:bg-gray-50 dark:hover:bg-gray-800/50">
                        <td class="px-4 py-3 text-gray-900 dark:text-gray-100">
                            {{ \Carbon\Carbon::parse($detail->presensiMadrasah->tanggal)->format('d/m/Y') }}
                        </td>
                        <td class="px-4 py-3 text-gray-900 dark:text-gray-100">
                            {{ $detail->presensiMadrasah->jenisPresensiMadrasah->nama ?? '-' }}
                        </td>
                        <td class="px-4 py-3">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                @if($detail->status === 'sakit') bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200
                                @elseif($detail->status === 'izin') bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200
                                @elseif($detail->status === 'alpha') bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200
                                @elseif($detail->status === 'cabut') bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-200
                                @elseif($detail->status === 'terlambat') bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-200
                                @endif">
                                {{ ucfirst($detail->status) }}
                            </span>
                        </td>
                        <td class="px-4 py-3 text-gray-900 dark:text-gray-100">
                            {{ $detail->keterangan }}
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    
    <div class="text-xs text-gray-500 dark:text-gray-400 mt-4">
        Total: {{ $details->count() }} keterangan
    </div>
</div>
