<!DOCTYPE html>
<html>
<head>
    <title>Laporan Presensi Madrasah</title>
    <style>
        @page { size: A4 landscape; margin: 15mm; }
        body { font-family: sans-serif; font-size: 11px; margin: 0; padding: 0; }
        .page-break { page-break-after: always; }
        .header { text-align: center; margin-bottom: 10px;  padding-bottom: 2px; }
        .header h2, .header h3, .header p { margin: 2px 0; }
        .details { margin-bottom: 10px; }
        .details table { width: 100%; border: none; }
        .details td { padding: 2px; }
        .table-data { width: 100%; border-collapse: collapse; margin-top: 8px; font-size: 10px; }
        .table-data th, .table-data td { border: 1px solid #000; padding: 4px; text-align: center; }
        .table-data th { background-color: #f0f0f0; }
        .text-left { text-align: left !important; }
        .nama-siswa { font-size: 9px; }
        .signature { margin-top: 20px; page-break-inside: avoid; }
        .signature table { width: 100%; border: none; }
        .signature td { padding: 8px; vertical-align: top; text-align: center; }
        .signature p { margin: 3px 0; }
        .signature .space { height: 50px; }
    </style>
</head>
<body>

@php
    $base64_mts = '';
    $path_mts = public_path('asset/KOP-MTS.png');
    if (file_exists($path_mts)) {
        $base64_mts = 'data:image/' . pathinfo($path_mts, PATHINFO_EXTENSION) . ';base64,' . base64_encode(file_get_contents($path_mts));
    }

    $base64_ma = '';
    $path_ma = public_path('asset/KOP-MA.png');
    if (file_exists($path_ma)) {
        $base64_ma = 'data:image/' . pathinfo($path_ma, PATHINFO_EXTENSION) . ';base64,' . base64_encode(file_get_contents($path_ma));
    }
@endphp

@foreach($classes as $kelas)
    @foreach($jenisPresensis as $jenis)
        <div class="page-break">
            <!-- Kop Surat -->
            <div class="header">
                @php
                    $isMts = str_contains(strtolower($kelas->madrasah->nama ?? ''), 'mts');
                    $current_kop = $isMts ? $base64_mts : $base64_ma;
                @endphp
                @if($current_kop)
                    <img src="{{ $current_kop }}" style="width: 100%; height: auto;">
                @endif
            </div>
         
            <!-- Report Info -->
            <div class="details">
                <table>
                    <tr>
                        <td width="15%"><strong>Laporan</strong></td>
                        <td width="2%">:</td>
                        <td>Presensi {{ $jenis->nama }}</td>
                        <td width="15%"><strong>Kelas</strong></td>
                        <td width="2%">:</td>
                        <td>{{ $kelas->nama }}</td>
                    </tr>
                    <tr>
                        <td><strong>Tanggal</strong></td>
                        <td>:</td>
                        <td>
                            @if(!empty($filters['dari']))
                                {{ \Carbon\Carbon::parse($filters['dari'])->format('d M Y') }}
                            @else
                                Awal
                            @endif
                            s/d
                            @if(!empty($filters['sampai']))
                                {{ \Carbon\Carbon::parse($filters['sampai'])->format('d M Y') }}
                            @else
                                Akhir
                            @endif
                        </td>
                        <td><strong>Wali Kelas</strong></td>
                        <td>:</td>
                        <td>{{ $kelas->waliKelas->name ?? '-' }}</td>
                    </tr>
                </table>
            </div>

            <!-- Table -->
            <table class="table-data">
                <thead>
                    <tr>
                        <th width="3%">No</th>
                        <th width="10%">NISN</th>
                        <th width="18%">Nama Siswa</th>
                        <th width="5%">H</th>
                        <th width="5%">S</th>
                        <th width="5%">I</th>
                        <th width="5%">A</th>
                        <th width="5%">C</th>
                        <th width="5%">T</th>
                        <th width="6%">%</th>
                        <th width="33%">Keterangan</th>
                    </tr>
                </thead>
                <tbody>
                    @php 
                        $no = 1; 
                        $hasData = false;
                    @endphp
                    @foreach($kelas->siswas as $siswa)
                        @php
                            // Optimized: Use the pre-calculated aggregate array
                            // Structure: $attendanceData[siswa_id][jenis_id][status] = count
                            $studentStats = $attendanceData[$siswa->id][$jenis->id] ?? [];

                            $hadir = $studentStats['hadir'] ?? 0;
                            $sakit = $studentStats['sakit'] ?? 0;
                            $izin = $studentStats['izin'] ?? 0;
                            $alpha = $studentStats['alpha'] ?? 0;
                            $cabut = $studentStats['cabut'] ?? 0;
                            $terlambat = $studentStats['terlambat'] ?? 0;
                            
                            $total = $hadir + $sakit + $izin + $alpha + $cabut + $terlambat;
                            if ($total > 0) $hasData = true; 
                            $percent = $total > 0 ? round(($hadir / $total) * 100, 1) : 0;

                            // Get keterangan summary
                            $keteranganList = $keteranganData[$siswa->id][$jenis->id] ?? [];
                            $keteranganText = '';
                            if (!empty($keteranganList)) {
                                // Group by status and show count
                                $grouped = [];
                                foreach ($keteranganList as $ket) {
                                    $status = $ket['status'];
                                    if (!isset($grouped[$status])) {
                                        $grouped[$status] = [];
                                    }
                                    $grouped[$status][] = $ket['keterangan'];
                                }
                                
                                $parts = [];
                                foreach ($grouped as $status => $keterangans) {
                                    $statusLabel = strtoupper(substr($status, 0, 1)); // S, I, A, C, T
                                    $count = count($keterangans);
                                    // Show first keterangan as sample
                                    $sample = mb_substr($keterangans[0], 0, 30);
                                    if (mb_strlen($keterangans[0]) > 30) $sample .= '...';
                                    $parts[] = "{$statusLabel}: {$sample}" . ($count > 1 ? " (+".($count-1).")" : "");
                                }
                                $keteranganText = implode('; ', $parts);
                            }
                        @endphp
                        <tr>
                            <td>{{ $no++ }}</td>
                            <td>{{ $siswa->nisn }}</td>
                            <td class="text-left nama-siswa">{{ $siswa->nama }}</td>
                            <td>{{ $hadir }}</td>
                            <td>{{ $sakit }}</td>
                            <td>{{ $izin }}</td>
                            <td>{{ $alpha }}</td>
                            <td>{{ $cabut }}</td>
                            <td>{{ $terlambat }}</td>
                            <td>{{ $percent }}%</td>
                            <td class="text-left" style="font-size: 8px;">{{ $keteranganText ?: '-' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <!-- Signature -->
            <div class="signature">
                <table>
                    <tr>
                        <td width="50%">
                            <p>Mengetahui,<br>Kepala Madrasah</p>
                            <div class="space"></div>
                            <p><strong>{{ $kelas->madrasah->nama_kepala ?? '.........................' }}</strong></p>
                            <p><strong>{{ $kelas->madrasah->nip_kepala ?? '.........................' }}</strong></p>
                        </td>
                        <td width="50%">
                            <p>Padang Panjang, {{ date('d F Y') }}<br>Waka Bid. Kesiswaan</p>
                            <div class="space"></div>
                            <p><strong>{{ $kelas->madrasah->nama_waka_kesiswaan ?? '.........................' }}</strong></p>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    @endforeach
@endforeach

</body>
</html>
