<?php

namespace Database\Seeders;

use App\Models\Kelas;
use App\Models\Siswa;
use Illuminate\Database\Seeder;

class SiswaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $kelas = Kelas::all();

        if ($kelas->isEmpty()) {
            if ($this->command) {
                $this->command->error('No Kelas records found. Cannot seed Siswa. Please run KelasSeeder first.');
            }

            return;
        }

        // Jumlah siswa per kelas
        $siswaPerKelas = 30;

        foreach ($kelas as $kelasItem) {
            if ($this->command) {
                $this->command->info("Creating {$siswaPerKelas} students for class: {$kelasItem->nama} (Madrasah: {$kelasItem->madrasah->nama})");
            }

            Siswa::factory()->count($siswaPerKelas)->create([
                'madrasah_id' => $kelasItem->madrasah_id,
                'kelas_id' => $kelasItem->id,
            ]);
        }

        if ($this->command) {
            $totalSiswa = Siswa::count();
            $totalKelas = $kelas->count();
            $this->command->info("Successfully created {$totalSiswa} students across {$totalKelas} classes.");
        }
    }
}
