<?php

namespace Database\Seeders;

use App\Models\RiwayatKelas;
use App\Models\Siswa;
use App\Models\Kelas;
use App\Models\TahunAjaran;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Database\Seeder;

class RiwayatKelasSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        try {
            $siswa = Siswa::firstOrFail();
            $kelas = Kelas::firstOrFail();
            $tahun = TahunAjaran::firstOrFail();
        } catch (ModelNotFoundException $e) {
            if ($this->command) {
                $this->command->error('Missing parent data (Siswa/Kelas/TahunAjaran). Cannot seed RiwayatKelas.');
            }
            return;
        }

        RiwayatKelas::factory()->count(5)->create([
            'siswa_id' => $siswa->id,
            'kelas_id' => $kelas->id,
            'tahun_ajaran_id' => $tahun->id,
        ]);
    }
}
