<?php

namespace Database\Seeders;

use App\Models\Kamar;
use App\Models\Madrasah;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Database\Seeder;

class KamarSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Delete existing data for idempotency (using delete instead of truncate to avoid FK constraint issues)
        Kamar::query()->delete();

        $madrasahs = Madrasah::all();

        if ($madrasahs->isEmpty()) {
            if ($this->command) {
                $this->command->error('No Madrasah records found. Cannot seed Kamar.');
            }
            return;
        }

        // Configuration for kamar names per madrasah kode
        $kamarConfig = [
            'MTS001' => [
                'Abu Bakar',
                'Umar bin Khattab',
                'Utsman bin Affan',
                'Ali bin Abi Thalib',
                'Bilal bin Rabah',
            ],
            'MA001' => [
                'Salman Al-Farisi',
                'Abu Ubaidah bin Jarrah',
                'Thalhah bin Ubaidillah',
                'Zubair bin Awwam',
                'Sa\'d bin Abi Waqqash',
            ],
        ];

        foreach ($madrasahs as $madrasah) {
            $kode = $madrasah->kode;

            if (isset($kamarConfig[$kode])) {
                // Use specific configuration for this madrasah
                foreach ($kamarConfig[$kode] as $namaKamar) {
                    Kamar::factory()->create([
                        'madrasah_id' => $madrasah->id,
                        'nama_kamar' => $namaKamar,
                    ]);
                }
            } else {
                // Default behaviour: create 5 kamar per madrasah with random names
                Kamar::factory()->count(5)->create([
                    'madrasah_id' => $madrasah->id,
                ]);
            }
        }
    }
}
