<?php

namespace Database\Seeders;

use App\Models\DetailPresensiAsrama;
use App\Models\PresensiAsrama;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Database\Seeder;

class DetailPresensiAsramaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        try {
            $presensi = PresensiAsrama::firstOrFail();
        } catch (ModelNotFoundException $e) {
            if ($this->command) {
                $this->command->error('No PresensiAsrama found. Cannot seed DetailPresensiAsrama.');
            }
            return;
        }

        DetailPresensiAsrama::factory()->count(5)->create([
            'presensi_asrama_id' => $presensi->id,
        ]);
    }
}
