<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application\'s database.
     */
    public function run(): void
    {
        // Detect environment and run appropriate seeder
        $environment = app()->environment();

        if ($environment === 'production') {
            $this->command->warn('⚠ Running in PRODUCTION mode - seeding master data only');
            $this->call(ProductionSeeder::class);
        } else {
            $this->command->info('ℹ Running in DEVELOPMENT mode - seeding with dummy data');
            $this->call(DevelopmentSeeder::class);
        }
    }
}
