<?php

namespace Database\Seeders;

use App\Models\JenisPresensiAsrama;
use App\Models\Madrasah;
use Illuminate\Database\Seeder;

class AssignJenisPresensiAsramaMadrasahSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get madrasahs
        $mtsMadrasah = Madrasah::where('kode', 'MTS001')->first();
        $maMadrasah = Madrasah::where('kode', 'MA001')->first();

        if (!$mtsMadrasah || !$maMadrasah) {
            $this->command->error('Madrasah not found! Please run MadrasahSeeder first.');
            return;
        }

        $this->command->info("Assigning Jenis Presensi Asrama to Madrasahs...");
        $this->command->info("---");

        // Get all jenis presensi asrama that don't have madrasah_id yet
        $jenisPresensiList = JenisPresensiAsrama::whereNull('madrasah_id')->get();

        if ($jenisPresensiList->isEmpty()) {
            $this->command->info("All Jenis Presensi Asrama already have madrasah assigned.");
            return;
        }

        // For now, we'll duplicate each jenis presensi for both madrasahs
        // You can customize this logic based on your needs
        foreach ($jenisPresensiList as $jenis) {
            // Assign to MTs
            $jenis->update(['madrasah_id' => $mtsMadrasah->id]);
            $this->command->info("✓ Assigned '{$jenis->nama}' to {$mtsMadrasah->nama}");

            // Create duplicate for MA
            $jenisMA = $jenis->replicate();
            $jenisMA->madrasah_id = $maMadrasah->id;
            $jenisMA->save();
            $this->command->info("✓ Created '{$jenis->nama}' for {$maMadrasah->nama}");
        }

        $this->command->info("---");
        $this->command->info("Jenis Presensi Asrama assignment completed!");
        $this->command->info("Note: Each jenis presensi has been duplicated for both MTs and MA.");
        $this->command->info("You can customize them separately in the admin panel.");
    }
}
