<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('presensi_non_asramas', function (Blueprint $table) {
            $table->id();
            $table->date('tanggal');
            $table->foreignId('tahun_ajaran_id')->constrained();
            $table->foreignId('jenis_presensi_non_asrama_id')->constrained('jenis_presensi_non_asramas');
            $table->foreignId('kelas_id')->constrained();
            $table->foreignId('user_id')->constrained();
            $table->text('keterangan')->nullable();
            $table->boolean('is_locked')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('presensi_non_asramas');
    }
};
