<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('jenis_presensi_non_asramas', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->enum('kategori', ["ibadah","bahasa","kebersihan","olahraga","makan","pendidikan","lainnya"]);
            $table->enum('sifat', ["wajib","opsional"]);
            $table->text('deskripsi')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jenis_presensi_non_asramas');
    }
};
