<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('presensi_madrasahs', function (Blueprint $table) {
            $table->id();
            $table->date('tanggal');
            $table->foreignId('tahun_ajaran_id')->constrained();
            $table->foreignId('jenis_presensi_madrasah_id')->constrained();
            $table->foreignId('kelas_id')->constrained('kelas');
            $table->foreignId('user_id')->constrained();
            $table->text('keterangan')->nullable();
            $table->boolean('is_locked')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('presensi_madrasahs');
    }
};
