<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('jenis_presensi_madrasahs', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->enum('kategori', ["kbm","upacara","literasi","ekskul","lainnya"]);
            $table->text('deskripsi')->nullable();
            $table->foreignId('madrasah_id')->nullable()->constrained();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jenis_presensi_madrasahs');
    }
};
