<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('kelas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('madrasah_id')->constrained();
            $table->string('tingkat', 10);
            $table->string('nama', 50);
            $table->foreignId('wali_kelas_id')->nullable()->constrained('users');
            $table->foreignId('wali_kamar_id')->nullable()->constrained('users');
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('kelas');
    }
};
