<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('madrasahs', function (Blueprint $table) {
            $table->id();
            $table->string('kode', 10)->unique()->index();
            $table->string('nama');
            $table->text('alamat')->nullable();
            $table->string('logo')->nullable();
            $table->string('nama_kepala')->nullable();
            $table->string('email_kepala')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('madrasahs');
    }
};
