<?php

namespace Database\Factories;

use App\Models\JenisPresensiMadrasah;
use App\Models\Kelas;
use App\Models\PresensiMadrasah;
use App\Models\TahunAjaran;
use App\Models\User;
use App\Models\Madrasah;
use Illuminate\Database\Eloquent\Factories\Factory;

class PresensiMadrasahFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = PresensiMadrasah::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $tahun = TahunAjaran::inRandomOrder()->first() ?? TahunAjaran::factory()->create();
        $jenis = JenisPresensiMadrasah::inRandomOrder()->first() ?? JenisPresensiMadrasah::factory()->create();
        $kelas = Kelas::inRandomOrder()->first() ?? Kelas::factory()->create();
        $user = User::inRandomOrder()->first() ?? User::factory()->create();

        return [
            'tanggal' => fake()->date(),
            'tahun_ajaran_id' => $tahun->id,
            'jenis_presensi_madrasah_id' => $jenis->id,
            'kelas_id' => $kelas->id,
            'user_id' => $user->id,
            'keterangan' => fake()->text(),
            'is_locked' => fake()->boolean(),
        ];
    }
}
