<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\JenisPresensiMadrasah;
use App\Models\Madrasah;

class JenisPresensiMadrasahFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = JenisPresensiMadrasah::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $madrasah = Madrasah::inRandomOrder()->first() ?? Madrasah::factory()->create();

        return [
            'nama' => fake()->word(),
            'kategori' => fake()->randomElement(["kbm","upacara","literasi","ekskul","lainnya"]),
            'deskripsi' => fake()->text(),
            'madrasah_id' => $madrasah->id,
            'is_active' => fake()->boolean(),
        ];
    }
}
