<?php

namespace Database\Factories;

use App\Models\DetailPresensiNonAsrama;
use App\Models\PresensiNonAsrama;
use App\Models\Siswa;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\DetailPresensiNonAsrama>
 */
class DetailPresensiNonAsramaFactory extends Factory
{
    protected $model = DetailPresensiNonAsrama::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'presensi_non_asrama_id' => PresensiNonAsrama::factory(),
            'siswa_id' => Siswa::factory(),
            'status' => fake()->randomElement(['hadir', 'sakit', 'izin', 'alpha']),
            'keterangan' => fake()->optional(0.2)->sentence(),
        ];
    }
}
