<?php

namespace App\Providers;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Laravel\Boost\Mcp\Boost;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Filament\Support\Facades\FilamentView;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->bind(
            \Laravel\Boost\Install\CodeEnvironmentsDetector::class,
            \App\Boost\ExtendedCodeEnvironmentsDetector::class
        );
        //
        parent::register();
        FilamentView::registerRenderHook('panels::body.end', fn (): string => Blade::render("@vite('resources/js/app.js')"));
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Model::unguard();
        //  // Enforce HTTPS in production
        // if (config('app.env') === 'production') {
        //     URL::forceScheme('https');
        // }

        // // Atau gunakan ini untuk check dari header Cloudflare
        // if (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https') {
        //     URL::forceScheme('https');
        //     $_SERVER['HTTPS'] = 'on';
        // }
        Gate::define('viewApiDocs', function (User $user) {
            return true;
        });

        // Gate::policy()
        // Event::listen(function (\SocialiteProviders\Manager\SocialiteWasCalled $event) {
        //     $event->extendSocialite('discord', \SocialiteProviders\Google\Provider::class);
        // });
    }
}
