<?php

namespace App\Policies;

use App\Models\User;
use App\Models\PresensiNonAsrama;
use Illuminate\Auth\Access\HandlesAuthorization;

class PresensiNonAsramaPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('view_any_presensi::non::asrama');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, PresensiNonAsrama $presensiNonAsrama): bool
    {
        return $user->can('view_presensi::non::asrama');
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->can('create_presensi::non::asrama');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, PresensiNonAsrama $presensiNonAsrama): bool
    {
        return $user->can('update_presensi::non::asrama');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, PresensiNonAsrama $presensiNonAsrama): bool
    {
        return $user->can('delete_presensi::non::asrama');
    }

    /**
     * Determine whether the user can bulk delete.
     */
    public function deleteAny(User $user): bool
    {
        return $user->can('delete_any_presensi::non::asrama');
    }

    /**
     * Determine whether the user can permanently delete.
     */
    public function forceDelete(User $user, PresensiNonAsrama $presensiNonAsrama): bool
    {
        return $user->can('force_delete_presensi::non::asrama');
    }

    /**
     * Determine whether the user can permanently bulk delete.
     */
    public function forceDeleteAny(User $user): bool
    {
        return $user->can('force_delete_any_presensi::non::asrama');
    }

    /**
     * Determine whether the user can restore.
     */
    public function restore(User $user, PresensiNonAsrama $presensiNonAsrama): bool
    {
        return $user->can('restore_presensi::non::asrama');
    }

    /**
     * Determine whether the user can bulk restore.
     */
    public function restoreAny(User $user): bool
    {
        return $user->can('restore_any_presensi::non::asrama');
    }

    /**
     * Determine whether the user can replicate.
     */
    public function replicate(User $user, PresensiNonAsrama $presensiNonAsrama): bool
    {
        return $user->can('replicate_presensi::non::asrama');
    }

    /**
     * Determine whether the user can reorder.
     */
    public function reorder(User $user): bool
    {
        return $user->can('reorder_presensi::non::asrama');
    }
}
