<?php

namespace App\Policies;

use App\Models\User;
use App\Models\DetailPresensiAsrama;
use Illuminate\Auth\Access\HandlesAuthorization;

class DetailPresensiAsramaPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('view_any_detail::presensi::asrama');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, DetailPresensiAsrama $detailPresensiAsrama): bool
    {
        return $user->can('view_detail::presensi::asrama');
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->can('create_detail::presensi::asrama');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, DetailPresensiAsrama $detailPresensiAsrama): bool
    {
        return $user->can('update_detail::presensi::asrama');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, DetailPresensiAsrama $detailPresensiAsrama): bool
    {
        return $user->can('delete_detail::presensi::asrama');
    }

    /**
     * Determine whether the user can bulk delete.
     */
    public function deleteAny(User $user): bool
    {
        return $user->can('delete_any_detail::presensi::asrama');
    }

    /**
     * Determine whether the user can permanently delete.
     */
    public function forceDelete(User $user, DetailPresensiAsrama $detailPresensiAsrama): bool
    {
        return $user->can('force_delete_detail::presensi::asrama');
    }

    /**
     * Determine whether the user can permanently bulk delete.
     */
    public function forceDeleteAny(User $user): bool
    {
        return $user->can('force_delete_any_detail::presensi::asrama');
    }

    /**
     * Determine whether the user can restore.
     */
    public function restore(User $user, DetailPresensiAsrama $detailPresensiAsrama): bool
    {
        return $user->can('restore_detail::presensi::asrama');
    }

    /**
     * Determine whether the user can bulk restore.
     */
    public function restoreAny(User $user): bool
    {
        return $user->can('restore_any_detail::presensi::asrama');
    }

    /**
     * Determine whether the user can replicate.
     */
    public function replicate(User $user, DetailPresensiAsrama $detailPresensiAsrama): bool
    {
        return $user->can('replicate_detail::presensi::asrama');
    }

    /**
     * Determine whether the user can reorder.
     */
    public function reorder(User $user): bool
    {
        return $user->can('reorder_detail::presensi::asrama');
    }
}
