<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class PresensiNonAsrama extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'tanggal',
        'tahun_ajaran_id',
        'jenis_presensi_non_asrama_id',
        'kelas_id',
        'user_id',
        'keterangan',
        'is_locked',
    ];

    protected $casts = [
        'id' => 'integer',
        'tanggal' => 'date',
        'tahun_ajaran_id' => 'integer',
        'jenis_presensi_non_asrama_id' => 'integer',
        'kelas_id' => 'integer',
        'user_id' => 'integer',
        'is_locked' => 'boolean',
    ];

    public function tahunAjaran(): BelongsTo
    {
        return $this->belongsTo(TahunAjaran::class);
    }

    public function jenisPresensiNonAsrama(): BelongsTo
    {
        return $this->belongsTo(JenisPresensiNonAsrama::class);
    }

    public function kelas(): BelongsTo
    {
        return $this->belongsTo(Kelas::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function detailPresensiNonAsramas(): HasMany
    {
        return $this->hasMany(DetailPresensiNonAsrama::class);
    }
}
