<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class PresensiMadrasah extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'tanggal',
        'tahun_ajaran_id',
        'jenis_presensi_madrasah_id',
        'kelas_id',
        'user_id',
        'keterangan',
        'is_locked',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'tanggal' => 'date',
        'tahun_ajaran_id' => 'integer',
        'jenis_presensi_madrasah_id' => 'integer',
        'kelas_id' => 'integer',
        'user_id' => 'integer',
        'is_locked' => 'boolean',
    ];

    public function tahunAjaran(): BelongsTo
    {
        return $this->belongsTo(TahunAjaran::class);
    }

    public function jenisPresensiMadrasah(): BelongsTo
    {
        return $this->belongsTo(JenisPresensiMadrasah::class);
    }

    public function kelas(): BelongsTo
    {
        return $this->belongsTo(Kelas::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function detailPresensiMadrasahs(): HasMany
    {
        return $this->hasMany(DetailPresensiMadrasah::class);
    }
}
