<?php

namespace App\Models;

use App\Traits\HasMadrasahScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Kelas extends Model
{
    use HasFactory, SoftDeletes, HasMadrasahScope;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'madrasah_id',
        'tingkat',
        'nama',
        'wali_kelas_id',
        'wali_kamar_id',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'madrasah_id' => 'integer',
        'wali_kelas_id' => 'integer',
        'wali_kamar_id' => 'integer',
        'user_id' => 'integer',
    ];

    public function madrasah(): BelongsTo
    {
        return $this->belongsTo(Madrasah::class);
    }

    public function waliKelas(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function waliKamar(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function siswas(): HasMany
    {
        return $this->hasMany(Siswa::class);
    }

    public function presensiMadrasahs(): HasMany
    {
        return $this->hasMany(PresensiMadrasah::class);
    }

    public function riwayatKelas(): HasMany
    {
        return $this->hasMany(RiwayatKelas::class);
    }
}
