<?php

namespace App\Imports;

use App\Models\User;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;

class UserImport implements SkipsEmptyRows, ToCollection, WithBatchInserts, WithChunkReading, WithHeadingRow
{
    protected $errors = [];
    protected $successCount = 0;
    protected $failedCount = 0;
    protected $processedEmails = [];

    public function collection(Collection $rows)
    {
        foreach ($rows as $index => $row) {
            try {
                // Helper to get value with multiple potential header formats
                $getValue = function ($row, $keys) {
                    foreach ((array) $keys as $key) {
                        if (isset($row[$key]) && ! empty($row[$key])) {
                            return $row[$key];
                        }
                    }
                    return null;
                };

                $name = $getValue($row, ['name', 'nama']);
                $email = $getValue($row, ['email']);
                $password = $getValue($row, ['password', 'kata_sandi']);
                $role = $getValue($row, ['role', 'peran']);
                $madrasahId = $getValue($row, ['madrasah_id']);

                if (empty($name)) {
                    $this->errors[] = 'Baris ' . ($index + 2) . ': Nama wajib diisi';
                    $this->failedCount++;
                    continue;
                }

                if (empty($email)) {
                    $this->errors[] = 'Baris ' . ($index + 2) . ': Email wajib diisi';
                    $this->failedCount++;
                    continue;
                }

                // Check duplicate email in this session
                if (isset($this->processedEmails[$email])) {
                    $this->errors[] = 'Baris ' . ($index + 2) . ": Email '{$email}' duplikat dalam file";
                    $this->failedCount++;
                    continue;
                }

                $userData = [
                    'name' => $name,
                    'madrasah_id' => $madrasahId,
                ];

                if (!empty($password)) {
                    $userData['password'] = Hash::make($password);
                }

                $user = User::updateOrCreate(
                    ['email' => $email],
                    $userData
                );

                // Assign role if provided
                if (!empty($role)) {
                    // Assuming role is a name from Filament Shield/Spatie Permission
                    $user->syncRoles([$role]);
                }

                $this->processedEmails[$email] = $index + 2;
                $this->successCount++;
            } catch (\Exception $e) {
                $this->errors[] = 'Baris ' . ($index + 2) . ': ' . $e->getMessage();
                $this->failedCount++;
            }
        }
    }

    public function batchSize(): int
    {
        return 100;
    }

    public function chunkSize(): int
    {
        return 100;
    }

    public function getErrors()
    {
        return $this->errors;
    }

    public function getSuccessCount()
    {
        return $this->successCount;
    }

    public function getFailedCount()
    {
        return $this->failedCount;
    }
}
