<?php

namespace App\Filament\Resources\UserResource\Pages;

use App\Filament\Resources\UserResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateUser extends CreateRecord
{
    protected static string $resource = UserResource::class;
    protected static bool $canCreateAnother = false;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // Hash password
        if (isset($data['password'])) {
            $data['password'] = bcrypt($data['password']);
        }
        
        // Remove siswa_id from user data (will be handled after create)
        unset($data['siswa_id']);
        
        return $data;
    }

    protected function afterCreate(): void
    {
        // Link siswa to user if siswa_id is provided
        $siswaId = $this->data['siswa_id'] ?? null;
        
        if ($siswaId) {
            \App\Models\Siswa::where('id', $siswaId)->update(['user_id' => $this->record->id]);
        }
    }

    //customize redirect after create
    public function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
