<?php

namespace App\Filament\Resources\SiswaResource\Pages;

use App\Filament\Resources\SiswaResource;
use Filament\Actions;
use Filament\Resources\Components\Tab;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Database\Eloquent\Builder;

class ListSiswas extends ListRecords
{
    protected static string $resource = SiswaResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        return [
            'mts' => Tab::make('MTs')
                ->label('MTs')
                ->modifyQueryUsing(fn (Builder $query) => $query->whereHas('kelas', fn (Builder $q) => $q->whereIn('tingkat', ['VII', 'VIII', 'IX']))),

            'ma' => Tab::make('MA')
                ->label('MA')
                ->modifyQueryUsing(fn (Builder $query) => $query->whereHas('kelas', fn (Builder $q) => $q->whereIn('tingkat', ['X', 'XI', 'XII']))),
        ];
    }
}
