<?php

namespace App\Filament\Resources;

use App\Filament\Resources\MadrasahResource\Pages;
use App\Models\Madrasah;
use Filament\Forms;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Section;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\Layout\Split;
use Filament\Tables\Columns\Layout\Stack;
use Filament\Tables\Table;

class MadrasahResource extends Resource
{
    protected static ?string $model = Madrasah::class;

    protected static ?string $navigationIcon = 'heroicon-o-building-office-2';

    // make a first menu item
    protected static ?int $navigationSort = 3;

    protected static ?string $navigationGroup = 'Akademik';

    protected static ?string $pluralModelLabel = 'Madrasah';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Grid::make(['default' => 1, 'md' => 3])
                    ->schema([
                        Section::make('Informasi Madrasah')
                            ->columnSpan(1)
                            ->schema([
                                // Forms\Components\TextInput::make('kode')
                                //     ->required()
                                //     ->maxLength(255),
                                Forms\Components\TextInput::make('nama')
                                    ->required()
                                    ->maxLength(255),
                                Forms\Components\TextInput::make('nama_kepala')
                                    ->maxLength(255)
                                    ->default(null),
                                Forms\Components\TextInput::make('nip_kepala')
                                    ->label('NIP Kepala Sekolah')
                                    ->maxLength(255)
                                    ->default(null),
                                Forms\Components\TextInput::make('email_kepala')
                                    ->email()
                                    ->maxLength(255)
                                    ->default(null),
                                Forms\Components\TextInput::make('nama_waka_kesiswaan')
                                    ->label('Nama Waka Bid. Kesiswaan')
                                    ->maxLength(255)
                                    ->default(null),

                                Forms\Components\Textarea::make('alamat')
                                    ->columnSpanFull(),
                            ]),

                        Section::make('Informasi Asrama')
                            ->columnSpan(1)
                            ->schema([
                                Forms\Components\TextInput::make('nama_koordinator_asrama_putra')
                                    ->label('Koor. Asrama Putra')
                                    ->maxLength(255)
                                    ->default(null),
                                Forms\Components\TextInput::make('nama_koordinator_asrama_putri')
                                    ->label('Koor. Asrama Putri')
                                    ->maxLength(255)
                                    ->default(null),
                                Forms\Components\TextInput::make('nama_wadir_pengasuhan')
                                    ->label('Wadir III Bidang Pengasuhan')
                                    ->maxLength(255)
                                    ->default(null),
                                Forms\Components\TextInput::make('nama_mudir')
                                    ->label('Mudir')
                                    ->maxLength(255)
                                    ->default(null),
                            ]),
                        Section::make('Logo')
                            ->columnSpan(1)
                            ->schema([
                                FileUpload::make('logo')
                                    ->image()
                                    //  ->avatar()
                                    ->directory('madrasah-logos')
                                    ->imagePreviewHeight('250')
                                    ->loadingIndicatorPosition('left')
                                    ->panelAspectRatio('2:1')
                                    ->panelLayout('integrated')
                                    ->removeUploadedFileButtonPosition('right')
                                    ->uploadButtonPosition('left')
                                    ->uploadProgressIndicatorPosition('left')
                                    ->downloadable()
                                    ->deletable()
                                    ->uploadingMessage('Uploading attachment...')

                                    ->maxParallelUploads(1)
                                    ->nullable(),
                            ])->grow(false),

                    ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->heading('Nama Madrasah')
            ->columns([
                Split::make([

                    Tables\Columns\TextColumn::make('nama')
                        ->sortable(),

                    Stack::make([
                        Tables\Columns\TextColumn::make('nama_kepala'),
                        Tables\Columns\TextColumn::make('email_kepala')
                            ->icon('heroicon-m-envelope'),
                    ]),
                    ImageColumn::make('logo')
                        ->width(80)
                        ->height(80)
                        ->circular(),
                ]),
            ])

            ->searchable(false)
            ->paginated(false)
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                // Tables\Actions\DeleteAction::make(),

            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListMadrasahs::route('/'),
            'create' => Pages\CreateMadrasah::route('/create'),
            'edit' => Pages\EditMadrasah::route('/{record}/edit'),
        ];
    }
}
