<?php

namespace App\Filament\Resources\LaporanPresensiMadrasahResource\Pages;

use App\Filament\Resources\LaporanPresensiMadrasahResource;
use Filament\Resources\Pages\ListRecords;

class ListLaporanPresensiMadrasahs extends ListRecords
{
    protected static string $resource = LaporanPresensiMadrasahResource::class;

    protected function getHeaderActions(): array
    {
        return [
            \Filament\Actions\Action::make('pdf')
                ->label('Export PDF')
                ->icon('heroicon-o-document-arrow-down')
                ->form([
                    \Filament\Forms\Components\Select::make('madrasah_id')
                        ->label('Madrasah')
                        ->options(\App\Models\Madrasah::pluck('nama', 'id'))
                        ->live()
                        ->afterStateUpdated(fn (callable $set) => $set('kelas_id', null))
                        ->placeholder('Pilih Madrasah (Opsional - Kosongkan untuk semua)')
                        ->searchable(),

                    \Filament\Forms\Components\Select::make('kelas_id')
                        ->label('Kelas')
                        ->options(function (callable $get) {
                            $madrasahId = $get('madrasah_id');
                            $user = \Illuminate\Support\Facades\Auth::user();
                            $query = \App\Models\Kelas::query();

                            // Filter by selected madrasah from form
                            if ($madrasahId) {
                                $query->where('madrasah_id', $madrasahId);
                            }

                            // Role-based filtering
                            if ($user && ! $user->hasRole('super_admin')) {
                                $query->whereIn('tingkat', ['VII', 'VIII', 'IX', 'X', 'XI', 'XII']);
                            }

                            if ($user && ! $user->hasRole(['super_admin', 'pimpinan', 'operator'])) {
                                if ($userMadrasahId = $user->getMadrasahId()) {
                                    $query->where('madrasah_id', $userMadrasahId);
                                }
                            }

                            if ($user && $user->hasRole('walikelas')) {
                                $query->where('wali_kelas_id', $user->id);
                            }

                            return $query->orderByRaw("FIELD(tingkat, 'VII', 'VIII', 'IX', 'X', 'XI', 'XII')")
                                ->orderBy('nama')
                                ->pluck('nama', 'id');
                        })
                        ->placeholder('Pilih Kelas (Opsional - Kosongkan untuk semua)')
                        ->searchable(),

                    \Filament\Forms\Components\Select::make('tahun_ajaran_id')
                        ->label('Tahun Ajaran')
                        ->options(\App\Models\TahunAjaran::pluck('nama', 'id'))
                        ->default(\App\Models\TahunAjaran::where('is_aktif', true)->first()?->id)
                        ->required()
                        ->searchable(),

                    \Filament\Forms\Components\Select::make('jenis_presensi_madrasah_id')
                        ->label('Jenis Presensi')
                        ->options(\App\Models\JenisPresensiMadrasah::where('is_active', true)->pluck('nama', 'id'))
                        ->placeholder('Semua Jenis Presensi')
                        ->searchable(),

                    \Filament\Forms\Components\DatePicker::make('dari')
                        ->label('Dari Tanggal')
                        ->default(now()->startOfMonth()),

                    \Filament\Forms\Components\DatePicker::make('sampai')
                        ->label('Sampai Tanggal')
                        ->default(now()),
                ])
                ->modalHeading('Export Laporan PDF')
                ->modalDescription('Pilih filter untuk export laporan. Kosongkan Madrasah/Kelas untuk export semua data.')
                ->modalSubmitActionLabel('Export PDF')
                ->modalWidth('2xl')
                ->action(function (array $data) {
                    // Increase memory limit for PDF generation
                    ini_set('memory_limit', '2048M');
                    set_time_limit(300);

                    // Re-use logic from Export class but for direct View render
                    $export = new \App\Exports\LaporanMadrasahExport($data);
                    $view = $export->view();

                    $pdf = \Barryvdh\DomPDF\Facade\Pdf::loadView(
                        $view->name(),
                        $view->getData()
                    )->setPaper('a4', 'landscape');

                    return response()->streamDownload(function () use ($pdf) {
                        echo $pdf->output();
                    }, 'Laporan-Presensi-Madrasah-'.date('Y-m-d').'.pdf');
                }),
        ];
    }
}
