<?php

namespace App\Filament\Resources;

use App\Filament\Resources\JenisPresensiNonAsramaResource\Pages;
use App\Models\JenisPresensiNonAsrama;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class JenisPresensiNonAsramaResource extends Resource
{
    protected static ?string $model = JenisPresensiNonAsrama::class;

    protected static ?string $navigationIcon = 'heroicon-o-numbered-list';

    protected static ?string $pluralModelLabel = 'Jenis Presensi Non-Asrama';

    protected static ?string $navigationGroup = 'Kegiatan Pengasuhan';

    protected static ?int $navigationSort = 44;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make('Informasi Jenis Presensi Non-Asrama')
                    ->schema([
                        Forms\Components\TextInput::make('nama')
                            ->required()
                            ->maxLength(255)
                            ->columnSpanFull(),
                        Forms\Components\Select::make('kategori')
                            ->options([
                                'ibadah' => 'Ibadah',
                                'bahasa' => 'Bahasa',
                                'kebersihan' => 'Kebersihan',
                                'olahraga' => 'Olahraga',
                                'makan' => 'Makan',
                                'pendidikan' => 'Pendidikan',
                                'lainnya' => 'Lainnya',
                            ])
                            ->required(),
                        Forms\Components\Select::make('sifat')
                            ->options([
                                'wajib' => 'Wajib',
                                'opsional' => 'Opsional',
                            ])
                            ->required(),
                        Forms\Components\Textarea::make('deskripsi')
                            ->columnSpanFull(),
                        Forms\Components\Select::make('madrasah_id')
                            ->relationship('madrasah', 'nama')
                            ->searchable()
                            ->preload()
                            ->placeholder('Berlaku untuk Semua Madrasah')
                            ->helperText('Kosongkan jika berlaku untuk semua madrasah')
                            ->columnSpanFull(),
                        Forms\Components\Toggle::make('is_active')
                            ->label('Aktif')
                            ->default(true)
                            ->required(),
                    ])
                    ->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nama')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('kategori')
                    ->badge()
                    ->color(fn (string $state): string => match ($state) {
                        'ibadah' => 'primary',
                        'bahasa' => 'info',
                        'kebersihan' => 'success',
                        'olahraga' => 'warning',
                        'makan' => 'danger',
                        'pendidikan' => 'info',
                        'lainnya' => 'gray',
                    })
                    ->formatStateUsing(fn (string $state): string => ucfirst($state))
                    ->sortable(),
                Tables\Columns\TextColumn::make('sifat')
                    ->badge()
                    ->color(fn (string $state): string => match ($state) {
                        'wajib' => 'danger',
                        'opsional' => 'success',
                    })
                    ->formatStateUsing(fn (string $state): string => ucfirst($state))
                    ->sortable(),
                Tables\Columns\TextColumn::make('madrasah.nama')
                    ->label('Madrasah')
                    ->placeholder('Semua Madrasah')
                    ->sortable()
                    ->searchable(),
                Tables\Columns\IconColumn::make('is_active')
                    ->boolean()
                    ->label('Aktif'),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('kategori')
                    ->options([
                        'ibadah' => 'Ibadah',
                        'bahasa' => 'Bahasa',
                        'kebersihan' => 'Kebersihan',
                        'olahraga' => 'Olahraga',
                        'makan' => 'Makan',
                        'pendidikan' => 'Pendidikan',
                        'lainnya' => 'Lainnya',
                    ]),
                Tables\Filters\SelectFilter::make('sifat')
                    ->options([
                        'wajib' => 'Wajib',
                        'opsional' => 'Opsional',
                    ]),
                Tables\Filters\SelectFilter::make('madrasah_id')
                    ->relationship('madrasah', 'nama')
                    ->label('Madrasah'),
                Tables\Filters\TernaryFilter::make('is_active')
                    ->label('Status Aktif'),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListJenisPresensiNonAsramas::route('/'),
            'create' => Pages\CreateJenisPresensiNonAsrama::route('/create'),
            'edit' => Pages\EditJenisPresensiNonAsrama::route('/{record}/edit'),
        ];
    }
}
