<?php

namespace App\Filament\Resources;

use App\Filament\Resources\JenisPresensiMadrasahResource\Pages;
use App\Models\JenisPresensiMadrasah;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class JenisPresensiMadrasahResource extends Resource
{
    protected static ?string $model = JenisPresensiMadrasah::class;

    protected static ?string $navigationIcon = 'heroicon-o-list-bullet';

    protected static ?string $navigationGroup = 'Presensi Madrasah';

    protected static ?int $navigationSort = 2;

    protected static ?string $modelLabel = 'Jenis Presensi';

    protected static ?string $pluralModelLabel = 'Jenis Presensi';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make('Informasi Jenis Presensi')
                    ->schema([
                        Forms\Components\TextInput::make('nama')
                            ->required()
                            ->maxLength(255)
                            ->label('Nama Presensi'),
                        Forms\Components\Select::make('kategori')
                            ->required()
                            ->options([
                                'kbm' => 'KBM (Kegiatan Belajar Mengajar)',
                                'upacara' => 'Upacara',
                                'literasi' => 'Literasi',
                                'ekskul' => 'Ekstrakurikuler',
                                'lainnya' => 'Lainnya',
                            ])
                            ->searchable(),
                        Forms\Components\Select::make('madrasah_id')
                            ->relationship('madrasah', 'nama')
                            ->searchable()
                            ->preload()
                            ->placeholder('Berlaku untuk Semua Madrasah')
                            ->helperText('Kosongkan jika berlaku untuk semua madrasah'),
                        Forms\Components\Toggle::make('is_active')
                            ->label('Aktif')
                            ->default(true)
                            ->required(),
                        Forms\Components\Textarea::make('deskripsi')
                            ->rows(3)
                            ->columnSpanFull(),
                    ])
                    ->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nama')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('kategori')
                    ->badge()
                    ->color(fn (string $state): string => match ($state) {
                        'kbm' => 'primary',
                        'upacara' => 'danger',
                        'literasi' => 'info',
                        'ekskul' => 'success',
                        'lainnya' => 'gray',
                    }),
                Tables\Columns\TextColumn::make('madrasah.nama')
                    ->label('Madrasah')
                    ->placeholder('Semua Madrasah')
                    ->sortable()
                    ->searchable(),
                Tables\Columns\IconColumn::make('is_active')
                    ->boolean()
                    ->label('Aktif'),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('kategori')
                    ->options([
                        'kbm' => 'KBM',
                        'upacara' => 'Upacara',
                        'literasi' => 'Literasi',
                        'ekskul' => 'Ekstrakurikuler',
                        'lainnya' => 'Lainnya',
                    ]),
                Tables\Filters\SelectFilter::make('madrasah_id')
                    ->relationship('madrasah', 'nama')
                    ->label('Madrasah'),
                Tables\Filters\TernaryFilter::make('is_active')
                    ->label('Status Aktif'),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListJenisPresensiMadrasahs::route('/'),
            'create' => Pages\CreateJenisPresensiMadrasah::route('/create'),
            'edit' => Pages\EditJenisPresensiMadrasah::route('/{record}/edit'),
        ];
    }
}
