<?php

namespace App\Filament\Resources;

use App\Filament\Resources\DetailPresensiMadrasahResource\Pages;
use App\Models\DetailPresensiMadrasah;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class DetailPresensiMadrasahResource extends Resource
{
    protected static ?string $model = DetailPresensiMadrasah::class;

    protected static ?string $navigationIcon = 'heroicon-o-check';

    protected static ?string $pluralModelLabel = 'Detail Presensi Madrasah';

    // protected static ?string $navigationGroup = 'Presensi';

    protected static ?int $navigationSort = 61;

    // should register navigation false
    protected static bool $shouldRegisterNavigation = false;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('presensi_madrasah_id')
                    ->relationship('presensiMadrasah', 'nama')
                    ->required(),
                Forms\Components\Select::make('siswa_id')
                    ->relationship('siswa', 'nama')
                    ->required(),
                Forms\Components\TextInput::make('status')
                    ->required(),
                Forms\Components\Textarea::make('keterangan')
                    ->columnSpanFull(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('presensiMadrasah.id')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('siswa.id')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('status'),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),

            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListDetailPresensiMadrasahs::route('/'),
            'create' => Pages\CreateDetailPresensiMadrasah::route('/create'),
            'edit' => Pages\EditDetailPresensiMadrasah::route('/{record}/edit'),
        ];
    }
}
