<?php

namespace App\Filament\Exports;

use App\Models\Siswa;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;

class SiswaExporter extends Exporter
{
    protected static ?string $model = Siswa::class;

    // Disable queue untuk export langsung
    public function getJobQueue(): ?string
    {
        return null;
    }

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('id')
                ->label('ID'),
            ExportColumn::make('user.name'),
            ExportColumn::make('madrasah.id'),
            ExportColumn::make('kelas.id'),
            ExportColumn::make('nisn'),
            ExportColumn::make('nis'),
            ExportColumn::make('nik'),
            ExportColumn::make('nama'),
            ExportColumn::make('jenis_kelamin'),
            ExportColumn::make('tempat_lahir'),
            ExportColumn::make('tanggal_lahir'),
            ExportColumn::make('status_tempat_tinggal'),
            ExportColumn::make('kamar.id'),
            ExportColumn::make('no_kk'),
            ExportColumn::make('nama_ayah'),
            ExportColumn::make('nik_ayah'),
            ExportColumn::make('pendidikan_ayah'),
            ExportColumn::make('pekerjaan_ayah'),
            ExportColumn::make('nama_ibu'),
            ExportColumn::make('nik_ibu'),
            ExportColumn::make('pendidikan_ibu'),
            ExportColumn::make('pekerjaan_ibu'),
            ExportColumn::make('no_hp_ortu'),
            ExportColumn::make('alamat'),
            ExportColumn::make('provinsi'),
            ExportColumn::make('kabupaten_kota'),
            ExportColumn::make('kecamatan'),
            ExportColumn::make('desa_kelurahan'),
            ExportColumn::make('kode_pos'),
            ExportColumn::make('created_at'),
            ExportColumn::make('updated_at'),
            ExportColumn::make('deleted_at'),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $body = 'Your siswa export has completed and '.number_format($export->successful_rows).' '.str('row')->plural($export->successful_rows).' exported.';

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $body .= ' '.number_format($failedRowsCount).' '.str('row')->plural($failedRowsCount).' failed to export.';
        }

        return $body;
    }
}
