<?php

declare(strict_types=1);

namespace App;

use Laravel\Boost\Contracts\Agent;
use Laravel\Boost\Contracts\McpClient;
use Laravel\Boost\Install\CodeEnvironment\CodeEnvironment;
use Laravel\Boost\Install\Enums\McpInstallationStrategy;
use Laravel\Boost\Install\Enums\Platform;

class Antigravity extends CodeEnvironment implements Agent, McpClient
{
    public function name(): string
    {
        return 'antigravity';
    }

    public function displayName(): string
    {
        return 'Antigravity';
    }

    public function systemDetectionConfig(Platform $platform): array
    {
        // Detect by checking if the configuration directory exists
        return match ($platform) {
            Platform::Darwin, Platform::Linux => [
                'command' => 'test -d '.getenv('HOME').'/.gemini/antigravity',
            ],
            Platform::Windows => [
                // Assuming standard generic check for Windows if ever needed,
                // but this environment seems Linux-based.
                'command' => 'if exist %USERPROFILE%\\.gemini\\antigravity (exit 0) else (exit 1)',
            ],
        };
    }

    public function projectDetectionConfig(): array
    {
        return [
            'paths' => ['.antigravity'],
            'files' => ['ANTIGRAVITY.md'],
        ];
    }

    public function mcpInstallationStrategy(): McpInstallationStrategy
    {
        // Since we are reading from a static config file, we can use FILE strategy
        // or NONE if we don't want Boost to try and overwrite it easily without permission.
        // But FILE is standard for file-based configs.
        return McpInstallationStrategy::FILE;
    }

    public function mcpConfigPath(): string
    {
        return getenv('HOME').'/.gemini/antigravity/mcp_config.json';
    }

    public function guidelinesPath(): string
    {
        return 'GUIDELINES.md';
    }

    public function agentName(): ?string
    {
        return 'Antigravity';
    }

    public function frontmatter(): bool
    {
        return false;
    }

    public function mcpClientName(): ?string
    {
        return 'Antigravity';
    }
}
